#include <stdio.h>
#include "SN_manager.h"
#include "userprocess.h"

#define NUM_PROCESSES	5

int debug_level = 2;

void main()
{
	printf("Starting up...\n");

	// The manager handles passing of messages
	SN_Manager manager(NUM_PROCESSES);

	// We maintain the storage for the processes. Don't forget to delete later!
	User_Process *process_array[NUM_PROCESSES];

	int i;

	for(i = 0; i < NUM_PROCESSES; i++)
	{
		// Create the process
		process_array[i] = new User_Process(NUM_PROCESSES);

		// Add the process to the manager
		manager.Insert_Process(process_array[i]);
	}

	printf("Done initializing. Press enter to begin.\n");
	getchar();

	manager.Start_Sim();

	// I assume MS_Start returns when everything is done...
	for(i = 0; i < NUM_PROCESSES; i++)
	{
		delete process_array[i];
	}
}
